/*
 * Decompiled with CFR 0.152.
 */
package usbddjupdaterapp;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.TimeUnit;
import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.MidiDevice;
import javax.sound.midi.MidiMessage;
import javax.sound.midi.MidiSystem;
import javax.sound.midi.MidiUnavailableException;
import javax.sound.midi.Receiver;
import javax.sound.midi.ShortMessage;
import javax.sound.midi.SysexMessage;
import javax.sound.midi.Transmitter;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JProgressBar;
import javax.swing.LayoutStyle;
import javax.swing.Timer;

public class UsbDdjUpdaterApp
extends JDialog {
    private MidiDevice midiDeviceOutput = null;
    private MidiDevice midiDeviceInput = null;
    private Receiver midiDeviceReceiver = null;
    private Transmitter midiDeviceTransmitter = null;
    private MidiDevice.Info outputIndex;
    private MidiDevice.Info inputIndex;
    private MidiDevice.Info[] midiDeviceList;
    private int midiDeviceCnt;
    private int[] midiShowList;
    private int[] defineDataArr = new int[128];
    private int txPid;
    private int txVid;
    private int rxPid;
    private int rxVid;
    private int startAdd;
    private int endAdd;
    private int updateVer;
    private int sendDataAdd;
    private int highByteAdd;
    private int midByteAdd;
    private int lowByteAdd;
    private int checkSumVolume;
    private int rxAddressFlag;
    private int workStateFlag;
    private int connectCnt;
    private String deviceStr;
    private String buttonStr1;
    private String buttonStr2;
    private String currentStr;
    private String updateStr;
    private Boolean deviceStateFlag;
    private Boolean connectStateFlag;
    private Object[] options = new Object[]{"Close"};
    final int WORK_STATE_FLAG_READY = 1;
    final int WORK_STATE_FLAG_START = 2;
    final int WORK_STATE_FLAG_SUCCESS = 3;
    final int WORK_STATE_FLAG_FAIL = 4;
    final int WORK_STATE_FLAG_NOT_CONNECT = 5;
    private JButton BtClose;
    private JButton BtStart;
    private JLabel LabelCurVer;
    private JLabel LabelDeviceName;
    private JLabel LabelMessage1;
    private JLabel LabelMessage2;
    private JLabel LabelUpgVer;
    private JProgressBar ProgressBar;

    public UsbDdjUpdaterApp(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
        this.initEvent();
        this.getUpdateFileEvent();
    }

    public void initEvent() {
        this.buttonStr2 = "";
        this.buttonStr1 = "";
        this.deviceStr = "";
        this.currentStr = "Current Version: Ver. ";
        this.updateStr = "Update Version: Ver. ";
        this.rxVid = 0;
        this.rxPid = 0;
        this.txVid = 0;
        this.txPid = 0;
        this.endAdd = 0;
        this.startAdd = 0;
        this.updateVer = 0;
        this.deviceStateFlag = this.connectStateFlag = Boolean.valueOf(false);
        this.rxAddressFlag = 0;
        this.workStateFlag = 1;
        this.ProgressBar.setVisible(false);
    }

    public void systemTimeoutCountEvent() {
        ActionListener taskPerformer = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                if (UsbDdjUpdaterApp.this.deviceStateFlag.booleanValue() && UsbDdjUpdaterApp.this.workStateFlag < 3) {
                    if (UsbDdjUpdaterApp.this.connectStateFlag.booleanValue()) {
                        UsbDdjUpdaterApp.this.connectStateFlag = false;
                    } else {
                        UsbDdjUpdaterApp.this.sendShortMessageEvent(159, 127, 1);
                        UsbDdjUpdaterApp.this.connectCnt++;
                        if (UsbDdjUpdaterApp.this.connectCnt > 10) {
                            UsbDdjUpdaterApp.this.workStateFlag = 5;
                            JOptionPane.showOptionDialog(null, "Your " + UsbDdjUpdaterApp.this.deviceStr + " is not connected.", "Updater Program", -1, 2, null, UsbDdjUpdaterApp.this.options, UsbDdjUpdaterApp.this.options[0]);
                            System.exit(0);
                        }
                    }
                }
            }
        };
        new Timer(1000, taskPerformer).start();
    }

    public void getUpdateFileEvent() {
        InputStream inStream = this.getClass().getResourceAsStream("/updater.bin");
        if (inStream == null) {
            JOptionPane.showOptionDialog(null, "updater.bin file is not exist.", "Updater Program", -1, 2, null, this.options, this.options[0]);
            System.exit(0);
        } else {
            try {
                int i;
                int readData;
                BufferedInputStream bufInStream = new BufferedInputStream(inStream);
                bufInStream.skip(0L);
                int cnt = 0;
                while ((readData = bufInStream.read()) != -1) {
                    this.defineDataArr[cnt++] = readData;
                    if (cnt < 128) continue;
                }
                for (i = 1; i <= this.defineDataArr[0]; ++i) {
                    this.deviceStr = this.deviceStr + Character.toString((char)this.defineDataArr[i]);
                }
                this.LabelDeviceName.setText("Updates the version of your " + this.deviceStr + " firmware.");
                for (i = 1; i <= this.defineDataArr[64]; ++i) {
                    this.buttonStr1 = this.buttonStr1 + Character.toString((char)this.defineDataArr[64 + i]);
                }
                for (i = 1; i <= this.defineDataArr[80]; ++i) {
                    this.buttonStr2 = this.buttonStr2 + Character.toString((char)this.defineDataArr[80 + i]);
                }
                this.LabelMessage1.setText("Start your " + this.deviceStr + " in update mode by pressing the power button while");
                this.LabelMessage2.setText("pressing the [" + this.buttonStr1 + "] button and the [" + this.buttonStr2 + "] button onf the left deck.");
                this.txVid = this.defineDataArr[32];
                this.txVid = this.txVid << 8 | this.defineDataArr[33];
                this.txPid = this.defineDataArr[34];
                this.txPid = this.txPid << 8 | this.defineDataArr[35];
                if (this.defineDataArr[36] != 0) {
                    this.updateStr = this.updateStr + Integer.toString(this.defineDataArr[36]);
                }
                this.updateStr = this.updateStr + Integer.toString(this.defineDataArr[37]) + ".";
                this.updateStr = this.updateStr + Integer.toString(this.defineDataArr[38]);
                this.updateStr = this.updateStr + Integer.toString(this.defineDataArr[39]);
                this.LabelUpgVer.setText(this.updateStr);
                this.updateVer = this.defineDataArr[36];
                this.updateVer = this.updateVer << 8 | this.defineDataArr[37];
                this.updateVer = this.updateVer << 8 | this.defineDataArr[38];
                this.updateVer = this.updateVer << 8 | this.defineDataArr[39];
                this.startAdd = this.defineDataArr[40];
                this.startAdd = this.startAdd << 8 | this.defineDataArr[41];
                this.startAdd = this.startAdd << 8 | this.defineDataArr[42];
                this.startAdd = this.startAdd << 8 | this.defineDataArr[43];
                this.endAdd = this.defineDataArr[44];
                this.endAdd = this.endAdd << 8 | this.defineDataArr[45];
                this.endAdd = this.endAdd << 8 | this.defineDataArr[46];
                this.endAdd = this.endAdd << 8 | this.defineDataArr[47];
                this.getMidiDeviceInfoEvent();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public void getMidiDeviceInfoEvent() {
        int i;
        String OldName1 = "";
        this.midiDeviceCnt = 0;
        this.midiDeviceList = MidiSystem.getMidiDeviceInfo();
        this.midiShowList = new int[this.midiDeviceList.length];
        for (i = 0; i < this.midiDeviceList.length; ++i) {
            try {
                String Name1;
                MidiDevice Device1 = MidiSystem.getMidiDevice(this.midiDeviceList[i]);
                if (Device1.getMaxTransmitters() == 0 || OldName1.equals(Name1 = this.midiDeviceList[i].getName().trim())) continue;
                for (int j = 0; j < this.midiDeviceList.length; ++j) {
                    try {
                        String Name2;
                        MidiDevice Device2 = MidiSystem.getMidiDevice(this.midiDeviceList[j]);
                        if (Device2.getMaxReceivers() == 0 || !Name1.equals(Name2 = this.midiDeviceList[j].getName().trim())) continue;
                        this.midiShowList[this.midiDeviceCnt++] = i;
                        break;
                    }
                    catch (MidiUnavailableException midiUnavailableException) {
                        // empty catch block
                    }
                }
                OldName1 = Name1;
                continue;
            }
            catch (MidiUnavailableException midiUnavailableException) {
                // empty catch block
            }
        }
        if (this.midiDeviceCnt > 0) {
            for (i = 0; i < this.midiDeviceCnt; ++i) {
                this.getInputOutputEvent(i);
                try {
                    this.sendShortMessageEvent(144, this.defineDataArr[32] >> 4, this.defineDataArr[32] & 0xF);
                    this.sendShortMessageEvent(145, this.defineDataArr[33] >> 4, this.defineDataArr[33] & 0xF);
                    this.sendShortMessageEvent(146, this.defineDataArr[34] >> 4, this.defineDataArr[34] & 0xF);
                    this.sendShortMessageEvent(147, this.defineDataArr[35] >> 4, this.defineDataArr[35] & 0xF);
                    TimeUnit.MILLISECONDS.sleep(500L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (!this.deviceStateFlag.booleanValue()) continue;
                this.connectCnt = 0;
                this.systemTimeoutCountEvent();
                break;
            }
            if (!this.deviceStateFlag.booleanValue()) {
                this.workStateFlag = 5;
                JOptionPane.showOptionDialog(null, "Your " + this.deviceStr + " is not connected.", "Updater Program", -1, 2, null, this.options, this.options[0]);
                System.exit(0);
            }
        }
    }

    public void getInputOutputEvent(int index) {
        try {
            this.inputIndex = this.midiDeviceList[this.midiShowList[index]];
            if (this.inputIndex == null) {
                JOptionPane.showOptionDialog(null, "midi device is not selected.", "Updater Program", -1, 2, null, this.options, this.options[0]);
                System.exit(0);
            } else {
                this.midiDeviceInput = MidiSystem.getMidiDevice(this.inputIndex);
                this.midiDeviceInput.open();
                this.midiDeviceTransmitter = this.midiDeviceInput.getTransmitter();
                String inputName = this.inputIndex.getName().trim();
                for (int i = 0; i < this.midiDeviceList.length; ++i) {
                    String outputName = this.midiDeviceList[i].getName().trim();
                    if (!inputName.equals(outputName)) continue;
                    try {
                        MidiDevice device = MidiSystem.getMidiDevice(this.midiDeviceList[i]);
                        if (device.getMaxReceivers() == 0) continue;
                        this.outputIndex = this.midiDeviceList[i];
                        this.midiDeviceOutput = MidiSystem.getMidiDevice(this.outputIndex);
                        this.midiDeviceOutput.open();
                        this.midiDeviceReceiver = this.midiDeviceOutput.getReceiver();
                        break;
                    }
                    catch (MidiUnavailableException midiUnavailableException) {
                        // empty catch block
                    }
                }
                this.usbRxInputDataEvent();
            }
        }
        catch (MidiUnavailableException midiUnavailableException) {
            // empty catch block
        }
    }

    public void usbRxInputDataEvent() {
        this.midiDeviceTransmitter.setReceiver(new Receiver(){

            @Override
            public void close() {
            }

            @Override
            public void send(MidiMessage message, long ts) {
                if (message instanceof ShortMessage) {
                    UsbDdjUpdaterApp.this.decodeMessage((ShortMessage)message);
                } else if (message instanceof SysexMessage) {
                    UsbDdjUpdaterApp.this.decodeMessage((SysexMessage)message);
                }
            }
        });
    }

    /*
     * Enabled aggressive block sorting
     */
    public void decodeMessage(ShortMessage message) {
        switch (message.getCommand()) {
            case 144: {
                int data = message.getData1() << 4 | message.getData2();
                switch (message.getChannel()) {
                    case 0: {
                        this.rxVid = data;
                        break;
                    }
                    case 1: {
                        this.rxVid = this.rxVid << 8 | data;
                        break;
                    }
                    case 2: {
                        this.rxPid = data;
                        break;
                    }
                    case 3: {
                        this.rxPid = this.rxPid << 8 | data;
                        break;
                    }
                    case 4: {
                        if (data > 9) {
                            data = 0;
                        }
                        if (data == 0) return;
                        this.currentStr = this.currentStr + Integer.toString(data);
                        break;
                    }
                    case 5: {
                        if (data > 9) {
                            data = 0;
                        }
                        this.currentStr = this.currentStr + Integer.toString(data) + ".";
                        break;
                    }
                    case 6: {
                        if (data > 9) {
                            data = 0;
                        }
                        this.currentStr = this.currentStr + Integer.toString(data);
                        break;
                    }
                    case 7: {
                        if (data > 9) {
                            data = 0;
                        }
                        this.currentStr = this.currentStr + Integer.toString(data);
                        if (this.txVid == this.rxVid && this.txPid == this.rxPid) {
                            this.deviceStateFlag = true;
                        }
                        if (this.workStateFlag != 1) return;
                        this.LabelCurVer.setText(this.currentStr);
                        break;
                    }
                    case 8: {
                        this.highByteAdd = data;
                        this.sendDataAdd = data << 16;
                        this.rxAddressFlag = 1;
                        break;
                    }
                    case 9: {
                        if (this.rxAddressFlag != 1) return;
                        this.midByteAdd = data;
                        this.sendDataAdd |= data << 8;
                        this.rxAddressFlag = 2;
                        break;
                    }
                    case 10: {
                        if (this.rxAddressFlag != 2 || this.workStateFlag >= 3) return;
                        this.lowByteAdd = data;
                        this.sendDataAdd |= data;
                        this.sendShortMessageEvent(152, (this.highByteAdd & 0xF0) >> 4, this.highByteAdd & 0xF);
                        this.sendShortMessageEvent(153, (this.midByteAdd & 0xF0) >> 4, this.midByteAdd & 0xF);
                        this.sendShortMessageEvent(154, (this.lowByteAdd & 0xF0) >> 4, this.lowByteAdd & 0xF);
                        this.sendUpdateDataOfShortMessageEvent();
                        this.sendShortMessageEvent(156, (this.checkSumVolume & 0xF000) >> 12, (this.checkSumVolume & 0xF00) >> 8);
                        this.sendShortMessageEvent(157, (this.checkSumVolume & 0xF0) >> 4, this.checkSumVolume & 0xF);
                        this.rxAddressFlag = 0;
                        int value = (this.sendDataAdd - this.startAdd) * 100 / (this.endAdd - this.startAdd) + 1;
                        this.ProgressBar.setString(Integer.toString(value) + "%");
                        this.ProgressBar.setValue(value);
                        this.connectCnt = 0;
                        this.connectStateFlag = true;
                        break;
                    }
                    case 15: {
                        if (message.getData1() != 127) return;
                        if (message.getData2() == 1) {
                            this.connectCnt = 0;
                            this.connectStateFlag = true;
                            break;
                        }
                        if (message.getData2() == 2) return;
                        if (message.getData2() == 3) {
                            this.workStateFlag = 3;
                            this.LabelDeviceName.setText("");
                            this.LabelCurVer.setText("The update of your version of the " + this.deviceStr);
                            this.LabelUpgVer.setText("firmware is now completed.");
                            this.BtClose.setVisible(false);
                            this.BtStart.setVisible(true);
                            this.BtStart.setText("Ok");
                            this.ProgressBar.setVisible(false);
                            break;
                        }
                        if (message.getData2() != 4) return;
                        this.workStateFlag = 4;
                        JOptionPane.showOptionDialog(null, "Your " + this.deviceStr + " is not recognized.\n1. Connect the USB-A terminal on your " + this.deviceStr + " and \nyour computer using a USB cable. \n2. Start your " + this.deviceStr + " in update mode by pressing \nthe power button while pressing the [" + this.buttonStr1 + "] button \nand the [" + this.buttonStr2 + "] button on the left deck.\n3. Restart this program.", "Updater Program", -1, 2, null, this.options, this.options[0]);
                        System.exit(0);
                    }
                }
                return;
            }
        }
    }

    public void decodeMessage(SysexMessage message) {
    }

    public void sendUpdateDataOfShortMessageEvent() {
        try {
            int readData;
            InputStream inStream = this.getClass().getResourceAsStream("/updater.bin");
            BufferedInputStream bufInStream = new BufferedInputStream(inStream);
            bufInStream.skip(this.sendDataAdd);
            this.checkSumVolume = 0;
            int cnt = 0;
            while ((readData = bufInStream.read()) != -1) {
                this.sendShortMessageEvent(155, readData >> 4, readData & 0xF);
                this.checkSumVolume += readData;
                if (++cnt < 128) continue;
                break;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void sendShortMessageEvent(int cmd, int data1, int data2) {
        ShortMessage shortMsg = new ShortMessage();
        try {
            shortMsg.setMessage(cmd, data1, data2);
            this.midiDeviceReceiver.send(shortMsg, -1L);
        }
        catch (InvalidMidiDataException invalidMidiDataException) {
            // empty catch block
        }
    }

    private void initComponents() {
        this.BtClose = new JButton();
        this.BtStart = new JButton();
        this.LabelDeviceName = new JLabel();
        this.LabelCurVer = new JLabel();
        this.LabelUpgVer = new JLabel();
        this.ProgressBar = new JProgressBar();
        this.LabelMessage1 = new JLabel();
        this.LabelMessage2 = new JLabel();
        this.setDefaultCloseOperation(0);
        this.setTitle("Updater Program");
        this.setCursor(new Cursor(0));
        this.setResizable(false);
        this.BtClose.setFont(new Font("Arial", 1, 12));
        this.BtClose.setText("Close");
        this.BtClose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                UsbDdjUpdaterApp.this.BtCloseActionPerformed(evt);
            }
        });
        this.BtStart.setFont(new Font("Arial", 1, 12));
        this.BtStart.setText("Start");
        this.BtStart.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                UsbDdjUpdaterApp.this.BtStartActionPerformed(evt);
            }
        });
        this.LabelDeviceName.setFont(new Font("Arial", 1, 12));
        this.LabelDeviceName.setText("Updates the version of your DDJ-XXX Next firmware.");
        this.LabelDeviceName.setCursor(new Cursor(0));
        this.LabelCurVer.setFont(new Font("Arial", 0, 12));
        this.LabelCurVer.setText("Current Version: Ver.");
        this.LabelUpgVer.setFont(new Font("Arial", 0, 12));
        this.LabelUpgVer.setText("Update Version: Ver.");
        this.ProgressBar.setBackground(new Color(0, 0, 0));
        this.ProgressBar.setFont(new Font("Arial", 0, 12));
        this.ProgressBar.setForeground(new Color(102, 102, 102));
        this.ProgressBar.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        this.ProgressBar.setStringPainted(true);
        this.LabelMessage1.setFont(new Font("Arial", 0, 12));
        this.LabelMessage1.setText("Start your DDJ-XXX in update mode by pressing the power button while");
        this.LabelMessage2.setFont(new Font("Arial", 0, 12));
        this.LabelMessage2.setText("pressing the [SHIFT] button and the [SYNC] button onf the left deck.");
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.LabelDeviceName, -1, 511, Short.MAX_VALUE).addGap(18, 18, 18)).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(24, 24, 24).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.LabelUpgVer, -1, -1, Short.MAX_VALUE).addComponent(this.LabelCurVer, -2, 342, -2)).addGap(68, 145, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(layout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.BtClose, -2, 100, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.BtStart, -2, 100, -2)).addComponent(this.ProgressBar, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.LabelMessage1, -1, -1, Short.MAX_VALUE).addComponent(this.LabelMessage2, -1, -1, Short.MAX_VALUE)).addGap(29, 29, 29)))))));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.LabelDeviceName, -2, 26, -2).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(1, 1, 1).addComponent(this.LabelMessage1, -2, 19, -2)).addGroup(layout.createSequentialGroup().addGap(18, 18, 18).addComponent(this.LabelMessage2, -2, 19, -2))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.LabelCurVer).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.LabelUpgVer).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.ProgressBar, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.BtStart, -2, 23, -2).addComponent(this.BtClose, -2, 23, -2)).addContainerGap()));
        this.setSize(new Dimension(555, 214));
        this.setLocationRelativeTo(null);
    }

    private void BtCloseActionPerformed(ActionEvent evt) {
        System.exit(0);
    }

    private void BtStartActionPerformed(ActionEvent evt) {
        if (this.deviceStateFlag.booleanValue()) {
            if (this.workStateFlag == 1) {
                this.sendShortMessageEvent(159, 127, 2);
                this.LabelMessage1.setText("");
                this.LabelMessage2.setText("");
                this.LabelCurVer.setText("");
                this.LabelUpgVer.setText("Please wait for a few moments until the update process is completed.");
                this.ProgressBar.setVisible(true);
                this.BtClose.setVisible(false);
                this.BtStart.setVisible(false);
                this.workStateFlag = 2;
            } else if (this.workStateFlag == 3) {
                System.exit(0);
            }
        }
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                UsbDdjUpdaterApp dialog = new UsbDdjUpdaterApp((Frame)new JFrame(), true);
                dialog.setVisible(true);
            }
        });
    }
}

